<?php
require_once __DIR__ . '/config/db.php';
require_once __DIR__ . '/config/env.php';

$pdo = db();
$sql = file_get_contents(__DIR__ . '/database.sql');
$pdo->exec($sql);

// Admin from env or defaults
$adminEmail = env('ADMIN_EMAIL', 'admin@vsms.local');
$adminPass = env('ADMIN_PASSWORD', 'Admin@123');
$adminHash = password_hash($adminPass, PASSWORD_BCRYPT);

$pdo->prepare("INSERT IGNORE INTO admins (name, email, password) VALUES ('Super Admin', :email, :pass)")
    ->execute([':email'=>$adminEmail, ':pass'=>$adminHash]);

// Sample categories
$cats = ['Bike','Car','SUV','Truck'];
$stmt = $pdo->prepare("INSERT INTO vehicle_categories (name, description) VALUES (:n, :d)");
foreach ($cats as $c) {
    $stmt->execute([':n'=>$c, ':d'=>"$c general service & repair"]);
}

// Sample mechanics
$mechs = [
    ['Ravi Kumar','ravi@example.com','9876543210','Engine Specialist'],
    ['Asha Singh','asha@example.com','9876501234','Electricals'],
    ['Imran Khan','imran@example.com','9876598765','Body & Paint']
];
$stm = $pdo->prepare("INSERT INTO mechanics (name,email,phone,specialization) VALUES (?,?,?,?)");
foreach ($mechs as $m) $stm->execute($m);

// Sample users
$uh = password_hash('User@123', PASSWORD_BCRYPT);
$pdo->prepare("INSERT IGNORE INTO users (name,email,phone,password,address) VALUES
 ('Anita Sharma','anita@example.com','9000000001',:p,'Noida'),
 ('Rohit Verma','rohit@example.com','9000000002',:p,'Delhi')")->execute([':p'=>$uh]);

// Sample enquiry & service
$pdo->prepare("INSERT INTO enquiries (user_id, subject, message) VALUES (1, 'Service timing', 'When can I get a slot?')")->execute();
$pdo->prepare("INSERT INTO services (user_id, vehicle_category_id, vehicle_model, vehicle_number, issue_description, status, service_charge, parts_charge, additional_charge, assigned_mechanic_id)
VALUES (1, 2, 'Hyundai i20', 'DL8CAF1234', 'Noise from engine bay', 'in-progress', 1200, 800, 0, 1)")->execute();

echo "Seed complete. Admin: $adminEmail / $adminPass\n";