<?php
require_once __DIR__ . '/../config/auth.php'; require_user();
require_once __DIR__ . '/../config/db.php';
$pdo=db();
$uid=$_SESSION['user']['id'];
$id=(int)($_GET['id']??0);
$stmt=$pdo->prepare("SELECT s.*, vc.name cat FROM services s JOIN vehicle_categories vc ON vc.id=s.vehicle_category_id WHERE s.id=? AND s.user_id=?");
$stmt->execute([$id,$uid]);
$s=$stmt->fetch();
if(!$s){ http_response_code(404); echo "Not found"; exit; }
?>
<!doctype html>
<html><head><meta charset="utf-8"><title>Service Slip #<?php echo $s['id']; ?></title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>@media print {.noprint{display:none}}</style></head>
<body class="p-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3>Service Amount Slip</h3>
    <button class="btn btn-primary noprint" onclick="window.print()">Print</button>
  </div>
  <table class="table">
    <tr><th>ID</th><td><?php echo $s['id']; ?></td></tr>
    <tr><th>Category</th><td><?php echo htmlspecialchars($s['cat']); ?></td></tr>
    <tr><th>Vehicle</th><td><?php echo htmlspecialchars($s['vehicle_model']); ?> (<?php echo htmlspecialchars($s['vehicle_number']); ?>)</td></tr>
    <tr><th>Status</th><td><?php echo $s['status']; ?></td></tr>
    <tr><th>Service Charge</th><td>₹<?php echo number_format($s['service_charge'],2); ?></td></tr>
    <tr><th>Parts Charge</th><td>₹<?php echo number_format($s['parts_charge'],2); ?></td></tr>
    <tr><th>Additional</th><td>₹<?php echo number_format($s['additional_charge'],2); ?></td></tr>
    <tr class="table-success"><th>Total</th><td><strong>₹<?php echo number_format($s['total_amount'],2); ?></strong></td></tr>
    <tr><th>Assigned Mechanic</th><td><?php echo $s['assigned_mechanic_id'] ?: '-'; ?></td></tr>
    <tr><th>Created</th><td><?php echo $s['created_at']; ?></td></tr>
  </table>
  <p class="text-muted">This is a system-generated slip.</p>
</body></html>