<?php
require_once __DIR__ . '/../config/auth.php'; require_user();
require_once __DIR__ . '/../config/db.php';
include __DIR__ . '/../includes/header.php';
$pdo=db();
$cats=$pdo->query("SELECT * FROM vehicle_categories ORDER BY name")->fetchAll();
if($_SERVER['REQUEST_METHOD']==='POST'){
  $stmt=$pdo->prepare("INSERT INTO services (user_id, vehicle_category_id, vehicle_model, vehicle_number, issue_description) VALUES (?,?,?,?,?)");
  $stmt->execute([$_SESSION['user']['id'], $_POST['vehicle_category_id'], $_POST['vehicle_model'], $_POST['vehicle_number'], $_POST['issue_description']]);
  echo '<div class="alert alert-success">Service request submitted.</div>';
}
$my=$pdo->prepare("SELECT s.*, vc.name cat FROM services s JOIN vehicle_categories vc ON vc.id=s.vehicle_category_id WHERE s.user_id=? ORDER BY s.id DESC");
$my->execute([$_SESSION['user']['id']]);
$my=$my->fetchAll();
?>
<h2>Request Service</h2>
<form method="post" class="mb-4">
  <div class="row g-3">
    <div class="col-md-4">
      <label class="form-label">Category</label>
      <select name="vehicle_category_id" class="form-select" required>
        <option value="">Select</option>
        <?php foreach($cats as $c): ?><option value="<?php echo $c['id'];?>"><?php echo htmlspecialchars($c['name']);?></option><?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-4"><label class="form-label">Vehicle Model</label><input name="vehicle_model" class="form-control" required></div>
    <div class="col-md-4"><label class="form-label">Vehicle Number</label><input name="vehicle_number" class="form-control" required></div>
  </div>
  <div class="mb-3 mt-3"><label class="form-label">Issue Description</label><textarea name="issue_description" class="form-control" rows="3" required></textarea></div>
  <button class="btn btn-primary">Submit</button>
</form>

<h3>My Service Requests</h3>
<table class="table table-striped">
  <thead><tr><th>#</th><th>Category</th><th>Model</th><th>Number</th><th>Status</th><th>Total</th><th>Slip</th></tr></thead>
  <tbody>
  <?php foreach($my as $s): ?>
    <tr>
      <td><?php echo $s['id']; ?></td>
      <td><?php echo htmlspecialchars($s['cat']); ?></td>
      <td><?php echo htmlspecialchars($s['vehicle_model']); ?></td>
      <td><?php echo htmlspecialchars($s['vehicle_number']); ?></td>
      <td><span class="badge bg-<?php echo $s['status']==='completed'?'success':($s['status']==='rejected'?'danger':'warning'); ?>"><?php echo $s['status']; ?></span></td>
      <td>₹<?php echo number_format($s['total_amount'] ?? 0,2); ?></td>
      <td><a class="btn btn-sm btn-outline-secondary" href="service_slip.php?id=<?php echo $s['id']; ?>" target="_blank">Print</a></td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>
<?php include __DIR__ . '/../includes/footer.php'; ?>