<?php
// Simple .env loader
function env($key, $default = null) {
    static $vars = null;
    if ($vars === null) {
        $vars = [];
        $root = dirname(__DIR__);
        $envFile = $root . DIRECTORY_SEPARATOR . '.env';
        if (!file_exists($envFile)) {
            $envFile = $root . DIRECTORY_SEPARATOR . '.env.example';
        }
        if (file_exists($envFile)) {
            $lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
            foreach ($lines as $line) {
                if (str_starts_with(trim($line), '#')) continue;
                if (!str_contains($line, '=')) continue;
                [$k, $v] = array_map('trim', explode('=', $line, 2));
                $vars[$k] = trim($v, ""'");
            }
        }
        // Allow real environment to override
        foreach ($_ENV as $k => $v) $vars[$k] = $v;
        foreach ($_SERVER as $k => $v) if (getenv($k) !== false) $vars[$k] = getenv($k);
    }
    return $vars[$key] ?? $default;
}