<?php require_once __DIR__ . '/../config/auth.php'; require_admin();
require_once __DIR__ . '/../config/db.php'; include __DIR__ . '/../includes/header.php';
$pdo=db();
if($_SERVER['REQUEST_METHOD']==='POST'){
  if(isset($_POST['create'])){
    $pdo->prepare("INSERT INTO mechanics (name,email,phone,specialization,is_active) VALUES (?,?,?,?,1)")
        ->execute([$_POST['name'],$_POST['email'],$_POST['phone'],$_POST['specialization']]);
  } elseif(isset($_POST['update'])){
    $pdo->prepare("UPDATE mechanics SET name=?,email=?,phone=?,specialization=?, is_active=? WHERE id=?")
        ->execute([$_POST['name'],$_POST['email'],$_POST['phone'],$_POST['specialization'], isset($_POST['is_active'])?1:0, $_POST['id']]);
  } elseif(isset($_POST['delete'])){
    $pdo->prepare("DELETE FROM mechanics WHERE id=?")->execute([$_POST['id']]);
  }
}
$rows=$pdo->query("SELECT * FROM mechanics ORDER BY id DESC")->fetchAll();
?>
<h2>Mechanics</h2>
<form method="post" class="row g-2 mb-3">
  <input type="hidden" name="create" value="1">
  <div class="col-md-3"><input class="form-control" name="name" placeholder="Name" required></div>
  <div class="col-md-3"><input class="form-control" name="email" placeholder="Email" required></div>
  <div class="col-md-2"><input class="form-control" name="phone" placeholder="Phone" required></div>
  <div class="col-md-3"><input class="form-control" name="specialization" placeholder="Specialization"></div>
  <div class="col-md-1"><button class="btn btn-primary w-100">Add</button></div>
</form>
<table class="table table-striped">
<thead><tr><th>#</th><th>Name</th><th>Contact</th><th>Spec</th><th>Active</th><th>Actions</th></tr></thead>
<tbody>
<?php foreach($rows as $r): ?>
<tr>
  <form method="post">
  <td><?php echo $r['id']; ?><input type="hidden" name="id" value="<?php echo $r['id'];?>"></td>
  <td><input class="form-control" name="name" value="<?php echo htmlspecialchars($r['name']);?>"></td>
  <td><div class="d-flex gap-2"><input class="form-control" name="email" value="<?php echo htmlspecialchars($r['email']);?>"><input class="form-control" name="phone" value="<?php echo htmlspecialchars($r['phone']);?>"></div></td>
  <td><input class="form-control" name="specialization" value="<?php echo htmlspecialchars($r['specialization']);?>"></td>
  <td><input class="form-check-input" type="checkbox" name="is_active" <?php if($r['is_active']) echo 'checked';?>></td>
  <td>
    <button class="btn btn-sm btn-success" name="update" value="1">Save</button>
    <button class="btn btn-sm btn-danger" name="delete" value="1" onclick="return confirm('Delete?')">Delete</button>
  </td>
  </form>
</tr>
<?php endforeach; ?>
</tbody>
</table>
<?php include __DIR__ . '/../includes/footer.php'; ?>