<?php require_once __DIR__ . '/../config/auth.php'; require_admin();
require_once __DIR__ . '/../config/db.php'; include __DIR__ . '/../includes/header.php';
$pdo=db();
$q=trim($_GET['q']??'');
$sql="SELECT e.*, u.name uname, u.email uemail, u.phone uphone FROM enquiries e JOIN users u ON u.id=e.user_id";
$params=[];
if($q!==''){
  $sql.=" WHERE u.phone LIKE ? OR u.email LIKE ? OR u.name LIKE ?";
  $params=["%$q%","%$q%","%$q%"];
}
$sql.=" ORDER BY e.id DESC";
$stmt=$pdo->prepare($sql); $stmt->execute($params); $rows=$stmt->fetchAll();

if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['respond_id'])){
  $pdo->prepare("UPDATE enquiries SET status='responded', admin_response=? WHERE id=?")->execute([$_POST['response'], $_POST['respond_id']]);
  header("Location: enquiries.php"); exit;
}
?>
<h2>Customer Queries</h2>
<form class="mb-3" method="get">
  <div class="input-group">
    <input class="form-control" name="q" value="<?php echo htmlspecialchars($q);?>" placeholder="Search by phone, email, or name">
    <button class="btn btn-outline-secondary">Search</button>
  </div>
</form>
<table class="table table-striped">
<thead><tr><th>#</th><th>Customer</th><th>Subject</th><th>Status</th><th>Response</th><th>Action</th></tr></thead>
<tbody>
<?php foreach($rows as $r): ?>
<tr>
  <td><?php echo $r['id'];?></td>
  <td><div><?php echo htmlspecialchars($r['uname']);?></div><div class="small text-muted"><?php echo htmlspecialchars($r['uemail']);?> • <?php echo htmlspecialchars($r['uphone']);?></div></td>
  <td><?php echo htmlspecialchars($r['subject']);?></td>
  <td><span class="badge bg-<?php echo $r['status']==='responded'?'success':'secondary';?>"><?php echo $r['status'];?></span></td>
  <td class="small"><?php echo $r['admin_response']?htmlspecialchars($r['admin_response']):'-';?></td>
  <td>
    <form method="post" class="d-flex gap-2">
      <input type="hidden" name="respond_id" value="<?php echo $r['id'];?>">
      <input class="form-control form-control-sm" name="response" placeholder="Type response">
      <button class="btn btn-sm btn-primary">Respond</button>
    </form>
  </td>
</tr>
<?php endforeach; ?>
</tbody>
</table>
<?php include __DIR__ . '/../includes/footer.php'; ?>