<?php require_once __DIR__ . '/../config/auth.php'; require_admin();
require_once __DIR__ . '/../config/db.php'; include __DIR__ . '/../includes/header.php';
$pdo=db();
if($_SERVER['REQUEST_METHOD']==='POST'){
  if(isset($_POST['create'])){
    $pdo->prepare("INSERT INTO vehicle_categories (name,description) VALUES (?,?)")->execute([$_POST['name'],$_POST['description']]);
  } elseif(isset($_POST['update'])){
    $pdo->prepare("UPDATE vehicle_categories SET name=?, description=? WHERE id=?")->execute([$_POST['name'],$_POST['description'],$_POST['id']]);
  } elseif(isset($_POST['delete'])){
    $pdo->prepare("DELETE FROM vehicle_categories WHERE id=?")->execute([$_POST['id']]);
  }
}
$rows=$pdo->query("SELECT * FROM vehicle_categories ORDER BY id DESC")->fetchAll();
?>
<h2>Vehicle Categories</h2>
<form method="post" class="row g-2 mb-3">
  <input type="hidden" name="create" value="1">
  <div class="col-md-4"><input class="form-control" name="name" placeholder="Name" required></div>
  <div class="col-md-7"><input class="form-control" name="description" placeholder="Description"></div>
  <div class="col-md-1"><button class="btn btn-primary w-100">Add</button></div>
</form>
<table class="table table-striped">
<thead><tr><th>#</th><th>Name</th><th>Description</th><th>Actions</th></tr></thead>
<tbody>
<?php foreach($rows as $r): ?>
<tr>
  <form method="post">
  <td><?php echo $r['id']; ?><input type="hidden" name="id" value="<?php echo $r['id'];?>"></td>
  <td><input class="form-control" name="name" value="<?php echo htmlspecialchars($r['name']);?>"></td>
  <td><input class="form-control" name="description" value="<?php echo htmlspecialchars($r['description']);?>"></td>
  <td>
    <button class="btn btn-sm btn-success" name="update" value="1">Save</button>
    <button class="btn btn-sm btn-danger" name="delete" value="1" onclick="return confirm('Delete?')">Delete</button>
  </td>
  </form>
</tr>
<?php endforeach; ?>
</tbody>
</table>
<?php include __DIR__ . '/../includes/footer.php'; ?>